<?php
/**
 * Fired during plugin activation.
 *
 * This class defines all code necessary to run during the plugin's activation.
 *
 * @since      1.0
 * @package    WP_Shortcode
 * @subpackage WP_Shortcode/includes
 * @author     MyThemeShop <admin@mythemeshop.com>
 */
class WPS_Installer {

	/**
	 * Short Description. (use period)
	 *
	 * Long Description.
	 *
	 * @since	1.0
	 */
	public static function install() {
		add_option( 'wp_shortcode_db_version', wp_shortcode()->db_version );
		add_option( 'wp_shortcode_version', wp_shortcode()->version );
		self::add_settings();
	}

	public static function add_settings() {
		$preset_data = array( 'alert' => '{"alert-primary":{"id":"alert-primary","name":"Alert Primary","settings":{"type":"primary","class":"","content":"\u003Ch2\u003E\u003Cem\u003EThank you!\u003C\/em\u003E\u003C\/h2\u003E\u003Cem\u003EYour message has been successfully sent. We will contact you very soon!\u003C\/em\u003E"}},"alert-warning":{"id":"alert-warning","name":"Alert Warning","settings":{"type":"warning","class":"","content":"\u003Ch2\u003EFAILED!\u003C\/h2\u003ESomething went wrong, please try again later."}},"alert-note":{"id":"alert-note","name":"Alert Note","settings":{"type":"note","class":"","content":"\u003Ch2\u003EThanks!\u003C\/h2\u003EWe appreciate that you\u2019ve taken the time to write us. We\u2019ll get back to you very soon. Please come back and see us often."}},"alert-success":{"id":"alert-success","name":"Alert Success","settings":{"type":"success","class":"","content":"\u003Ch2\u003E\u003Cem\u003EThank you for contacting us.\u003C\/em\u003E\u003C\/h2\u003E\u003Cem\u003EWe have received your inquiry and will respond to you within 24 hours.  For urgent inquiries please call us on one of the telephone numbers below.\u003C\/em\u003E"}},"alert-announcement":{"id":"alert-announcement","name":"Alert Announcement","settings":{"type":"announce","class":"","content":"\u003Ch2\u003E\u003Cem\u003EThank you!\u003C\/em\u003E\u003C\/h2\u003EYour message has been successfully sent. We will contact you very soon!"}}}', 'dropcap' => '{"simple":{"id":"simple","name":"Simple","settings":{"size":"5","color":"#000000","background":"","border":"0 none","radius":"0","class":"","content":"A"}},"dropcap-background":{"id":"dropcap-background","name":"Dropcap background","settings":{"size":"3","color":"#ffffff","background":"#35ce8d","border":"0 none","radius":"6","class":"","content":"S"}},"rounded-dropcap":{"id":"rounded-dropcap","name":"Rounded Dropcap","settings":{"size":"3","color":"#ffffff","background":"#6aa2ff","border":"0 none","radius":"70","class":"","content":"S"}},"bordered-dropcap":{"id":"bordered-dropcap","name":"Bordered Dropcap","settings":{"size":"4","color":"#23395b","background":"","border":"2px solid #23395b","radius":"70","class":"","content":"P"}}}', 'frame' => '{"default-image-frame":{"id":"default-image-frame","name":"Default Image Frame","settings":{"style":"default","align":"center","class":"","content":"\u003Cimg src=\"https:\/\/demo.mythemeshop.com\/schema\/files\/2015\/12\/girl-checking-tumblr-on-her-macbook-pro-picjumbo-com-680x350.jpg\" \/\u003E"}},"zoom-in-animation":{"id":"zoom-in-animation","name":"Zoom-in Animation","settings":{"style":"style-1","align":"center","class":"","content":"\u003Cimg src=\"https:\/\/demo.mythemeshop.com\/schema\/files\/2015\/12\/girl-checking-tumblr-on-her-macbook-pro-picjumbo-com-680x350.jpg\" \/\u003E"}},"zoom-out-animation":{"id":"zoom-out-animation","name":"Zoom-out Animation","settings":{"style":"style-2","align":"center","class":"","content":"\u003Cimg src=\"https:\/\/demo.mythemeshop.com\/schema\/files\/2015\/12\/girl-checking-tumblr-on-her-macbook-pro-picjumbo-com-680x350.jpg\" \/\u003E"}},"shadow-frame":{"id":"shadow-frame","name":"Shadow Frame","settings":{"style":"style-3","align":"center","class":"","content":"\u003Cimg src=\"https:\/\/demo.mythemeshop.com\/schema\/files\/2015\/12\/girl-checking-tumblr-on-her-macbook-pro-picjumbo-com-680x350.jpg\" \/\u003E"}}}', 'lists' => '{"icon-list":{"id":"icon-list","name":"Icon List","settings":{"icon":"arrow-right","icon_color":"","class":"","content":"\u003Cul\u003E\n\u003Cli\u003EProin vestibulum. Ut ligula.\u003C\/li\u003E\n\u003Cli\u003ENec dictum nunc tortor id urna.\u003C\/li\u003E\n\u003Cli\u003ESuspendisse dapibus ullamcorper.\u003C\/li\u003E\n\u003C\/ul\u003E"}},"colored-icon-list":{"id":"colored-icon-list","name":"Colored Icon List","settings":{"icon":"heart","icon_color":"#dd9696","class":"","content":"\u003Cul\u003E\n\u003Cli\u003EProin vestibulum. Ut ligula.\u003C\/li\u003E\n\u003Cli\u003ENec dictum nunc tortor id urna.\u003C\/li\u003E\n\u003Cli\u003ESuspendisse dapibus ullamcorper.\u003C\/li\u003E\n\u003C\/ul\u003E"}}}', 'button' => '{"brown-button":{"id":"brown-button","name":"Brown Button","settings":{"style":"default","url":"#","target":"self","background":"#c5703f","color":"#FFFFFF","size":"13","icon":"heart-o","wide":"no","position":"left","radius":"0","text_shadow":"0px 0px 0px ","rel":"nofollow","title":"Brown Button","id":"","desc":"","class":"","content":"BROWN BUTTON"}},"blue-button":{"id":"blue-button","name":"Blue Button","settings":{"style":"default","url":"#","target":"self","background":"#a5b8da","color":"#FFFFFF","size":"13","icon":"cloud-download","wide":"no","position":"left","radius":"0","text_shadow":"0px 0px 0px ","rel":"nofollow","title":"Blue Button","id":"","desc":"","class":"","content":"BLUE BUTTON"}},"green-button":{"id":"green-button","name":"Green Button","settings":{"style":"default","url":"#","target":"self","background":"#6cb24c","color":"#FFFFFF","size":"13","icon":"check-square-o","wide":"no","position":"left","radius":"0","text_shadow":"0px 0px 0px ","rel":"nofollow","title":"Green Button","id":"","desc":"","class":"","content":"GREEN BUTTON"}},"red-button":{"id":"red-button","name":"Red Button","settings":{"style":"default","url":"#","target":"self","background":"#e83030","color":"#FFFFFF","size":"13","icon":"coffee","wide":"no","position":"left","radius":"0","text_shadow":"0px 0px 0px ","rel":"nofollow","title":"Red Button","id":"","desc":"","class":"","content":"RED BUTTON"}},"yellow-button":{"id":"yellow-button","name":"Yellow Button","settings":{"style":"default","url":"#","target":"self","background":"#ffda6b","color":"#FFFFFF","size":"13","icon":"dollar","wide":"no","position":"left","radius":"0","text_shadow":"0px 0px 0px ","rel":"nofollow","title":"Yellow Button","id":"","desc":"","class":"","content":"YELLOW BUTTON"}},"button-description":{"id":"button-description","name":"Button Description","settings":{"style":"default","url":"#","target":"self","background":"#576f9e","color":"#FFFFFF","size":"13","icon":"","wide":"no","position":"left","radius":"0","text_shadow":"0px 0px 0px ","rel":"nofollow","title":"Button Description","id":"","desc":"Sub title","class":"","content":"BUTTON TITLE"}},"stroked-button":{"id":"stroked-button","name":"Stroked Button","settings":{"style":"stroked","url":"#","target":"self","background":"#3d566e","color":"#FFFFFF","size":"13","icon":"edit","wide":"no","position":"left","radius":"0","text_shadow":"0px 0px 0px ","rel":"nofollow","title":"Stroked Button","id":"","desc":"Sub title","class":"","content":"STROKED BUTTON"}},"bordered-button":{"id":"bordered-button","name":"Bordered Button","settings":{"style":"bordered","url":"#","target":"self","background":"#16b5e5","color":"#FFFFFF","size":"13","icon":"","wide":"no","position":"left","radius":"0","text_shadow":"0px 0px 0px ","rel":"nofollow","title":"Bordered Button","id":"","desc":"","class":"","content":"BORDERED BUTTON"}},"3d-button":{"id":"3d-button","name":"3D Button","settings":{"style":"3d","url":"#","target":"self","background":"#3cc1a7","color":"#FFFFFF","size":"13","icon":"","wide":"no","position":"left","radius":"0","text_shadow":"0px 0px 0px ","rel":"nofollow","title":"3D Button","id":"","desc":"","class":"","content":"3D BUTTON"}}}', 'double_button' => '{"rounded-buttons":{"id":"rounded-buttons","name":"Rounded Buttons","settings":{"left_btn_text":"Login","left_desc":"Already a member?","left_url":"#","left_btn_target":"self","left_icon":"user","left_background":"#0eba17","left_color":"#FFFFFF","separator_text":"OR","right_btn_text":"Register","right_desc":"Not a member yet?","right_url":"#","right_btn_target":"self","right_icon":"user","right_background":"#f44f2e","right_color":"#FFFFFF","size":"13","radius":"100","class":"","content":"false"}},"square-buttons":{"id":"square-buttons","name":"Square Buttons","settings":{"left_btn_text":"Home","left_desc":"","left_url":"#","left_btn_target":"blank","left_icon":"home","left_background":"#89c4bd","left_color":"#FFFFFF","separator_text":"OR","right_btn_text":"Services","right_desc":"","right_url":"#","right_btn_target":"blank","right_icon":"users","right_background":"#898989","right_color":"#FFFFFF","size":"14","radius":"0","class":"","content":"false"}},"simple-buttons":{"id":"simple-buttons","name":"Simple Buttons","settings":{"left_btn_text":"Login","left_desc":"","left_url":"#","left_btn_target":"self","left_icon":"","left_background":"#333333","left_color":"#FFFFFF","separator_text":"OR","right_btn_text":"Register","right_desc":"","right_url":"#","right_btn_target":"self","right_icon":"","right_background":"#5e6475","right_color":"#FFFFFF","size":"13","radius":"0","class":"","content":"false"}}}', 'service' => '{"services-demo1":{"id":"services-demo1","name":"Services Demo1","settings":{"title":"RESEARCH","icon":"cog","icon_color":"#a2dce2","size":"32","class":"","content":"Aenean lacinia bibendum nulla sed dolor consectetur."}},"services-demo2":{"id":"services-demo2","name":"Services Demo2","settings":{"title":"DESIGN","icon":"bolt","icon_color":"#d66460","size":"32","class":"","content":"Aenean lacinia bibendum nulla sed dolor consectetur."}},"services-demo3":{"id":"services-demo3","name":"Services Demo3","settings":{"title":"DEVELOPMENT","icon":"html5","icon_color":"#d63a35","size":"32","class":"","content":"Aenean lacinia bibendum nulla sed dolor consectetur."}},"services-demo4":{"id":"services-demo4","name":"Services Demo4","settings":{"title":"SUPPORT","icon":"life-bouy","icon_color":"#70bfbc","size":"32","class":"","content":"Aenean lacinia bibendum nulla sed dolor consectetur."}}}', 'box' => '{"black-box":{"id":"black-box","name":"Black Box","settings":{"title":"Black Content Box","box_color":"#545454","title_color":"#FFFFFF","radius":"0","class":"","content":"\u003Ch3\u003EContent Box\u003C\/h3\u003E\nPellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra."}},"green-box":{"id":"green-box","name":"Green Box","settings":{"title":"Green Content Box","box_color":"#49a501","title_color":"#FFFFFF","radius":"5","class":"","content":"\u003Ch3\u003EContent Box\u003C\/h3\u003E\nPellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra."}},"blue-box":{"id":"blue-box","name":"Blue Box","settings":{"title":"Blue Content Box","box_color":"#53c5fe","title_color":"#FFFFFF","radius":"5","class":"","content":"\u003Ch3\u003EContent Box\u003C\/h3\u003E\nPellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra."}},"teal-box":{"id":"teal-box","name":"Teal Box","settings":{"title":"Teal Content Box","box_color":"#3cba9f","title_color":"#FFFFFF","radius":"5","class":"","content":"\u003Ch3\u003EContent Box\u003C\/h3\u003E\nPellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra."}},"golden-box":{"id":"golden-box","name":"Golden Box","settings":{"title":"Golden Content Box","box_color":"#fdbb0d","title_color":"#FFFFFF","radius":"5","class":"","content":"\u003Ch3\u003EContent Box\u003C\/h3\u003E\nPellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra."}}}', 'note' => '{"warning-note":{"id":"warning-note","name":"Warning note","settings":{"size":"14","background":"#ff5722","color":"#ffffff","radius":"0","class":"","content":"\u003Cstrong\u003EWarning!\u003C\/strong\u003E Better check yourself, you\'re not looking too good."}},"error-note":{"id":"error-note","name":"Error note","settings":{"size":"14","background":"#f44336","color":"#ffffff","radius":"0","class":"","content":"\u003Cstrong\u003EOh snap!\u003C\/strong\u003E Change a few things up and try submitting again."}},"info-note":{"id":"info-note","name":"Info note","settings":{"size":"14","background":"#03a9f4","color":"#ffffff","radius":"0","class":"","content":"\u003Cstrong\u003EHeads up!\u003C\/strong\u003E This alert needs your attention, but it\'s not super important."}},"success-note":{"id":"success-note","name":"Success note","settings":{"size":"14","background":"#28af2c","color":"#ffffff","radius":"0","class":"","content":"\u003Cstrong\u003EWell done!\u003C\/strong\u003E  You successfully read this important alert message."}}}','calltoaction' => '{"right-align-cta":{"id":"right-align-cta","name":"Right Align CTA","settings":{"style":"default","border":"none","title":"Call To Action Right Align","align":"right","background_image":"","background":"#daf6ea","color":"#535353","radius":"0","button_text":"Download","url":"#","target":"self","button_background":"#35ce8d","button_color":"#fff","button_radius":"4","class":"","content":"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat."}},"center-align-cta":{"id":"center-align-cta","name":"Center Align CTA","settings":{"style":"default","border":"none","title":"Call To Action Right Align","align":"center","background_image":"","background":"#d6e5ff","color":"#535353","radius":"0","button_text":"Download","url":"#","target":"self","button_background":"#6aa2ff","button_color":"#fff","button_radius":"4","class":"","content":"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat."}},"left-align-cta":{"id":"left-align-cta","name":"Left Align CTA","settings":{"style":"default","border":"none","title":"Call To Action Left Align","align":"left","background_image":"","background":"#f4f4f7","color":"#535353","radius":"0","button_text":"Download","url":"#","target":"self","button_background":"#6aa2ff","button_color":"#ffffff","button_radius":"0","class":"","content":"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat."}},"image-cta":{"id":"image-cta","name":"Image CTA","settings":{"style":"style-1","border":"none","title":"LOREM IPSUM DIN","align":"left","background_image":"https:\/\/demo.mythemeshop.com\/dividend\/files\/2017\/09\/call_to_action.jpg","background":"#23282d","color":"#ffffff","radius":"0","button_text":"","url":"#","target":"self","button_background":"#6aa2ff","button_color":"#fff","button_radius":"0","class":"","content":"Sed ut perspiciatis unde omnis iste natus error sit"}}}',
			'counter' => '{"counter-1":{"id":"counter-1","name":"Counter-1","settings":{"width":"250px","height":"150px","count_start":"0","count_end":"450000","align":"center","count_color":"#23395b","text_color":"#00001f","background":"#f4f4f7","border":"2px solid #e7eaed","radius":"5","prefix":"","suffix":"","separator":",","decimal":"","duration":"3","size":"small","class":"","content":"HAPPY CLIENTS"}},"counter-2":{"id":"counter-2","name":"Counter-2","settings":{"width":"250px","height":"150px","count_start":"0","count_end":"500","align":"center","count_color":"#6aa2ff","text_color":"#afafb6","background":"#f4f4f7","border":"0px  ","radius":"5","prefix":"","suffix":"","separator":",","decimal":"","duration":"3","size":"medium","class":"","content":"PROJECTS"}},"counter-3":{"id":"counter-3","name":"Counter-3","settings":{"width":"300px","height":"150px","count_start":"0","count_end":"9214859","align":"center","count_color":"#35ce8d","text_color":"#afafb6","background":"","border":"2px solid #dee0e3","radius":"5","prefix":"","suffix":"","separator":",","decimal":"","duration":"3","size":"large","class":"","content":"DOWNLOADS"}}}', 'countdown' => '{"default":{"id":"default","name":"Default","settings":{"style":"standard","date":"2018\/7\/13","time":"11:35:58","align":"center","size":"40","count_color":"#000000","background":"#eee","border":"","text_color":"","text_bg":"","padding":"20","class":"","content":"This offer has expired!"}},"countdown-1":{"id":"countdown-1","name":"CountDown-1","settings":{"style":"classic","date":"2018\/7\/13","time":"11:35:58","align":"center","size":"40","count_color":"#ffffff","background":"#23395b","border":"0px  ","text_color":"#adb3be","text_bg":"#32496a","padding":"20","class":"","content":"This offer has expired!"}},"countdown-2":{"id":"countdown-2","name":"CountDown-2","settings":{"style":"classic","date":"2018\/7\/13","time":"11:35:58","align":"left","size":"48","count_color":"#203453","background":"#ffffff","border":"1px solid #dee0e3","text_color":"#b3b3b3","text_bg":"#fafafb","padding":"20","class":"","content":"This offer has expired!"}}}', 'testimonial' => '{"simple-testimonial":{"id":"simple-testimonial","name":"Simple Testimonial","settings":{"style":"default","name":"Antonina","designation":"Executive Manager","company":"XYZ Ltd","url":"#","radius":"10","image":"https:\/\/demo.mythemeshop.com\/wp-testimonials\/files\/2015\/04\/176385.png","class":"","content":"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur."}},"styled-testimonial-1":{"id":"styled-testimonial-1","name":"Styled Testimonial-1","settings":{"style":"style-1","name":"Antonina","designation":"Executive Manager","company":"XYZ Ltd","url":"#","radius":"0","image":"https:\/\/demo.mythemeshop.com\/wp-testimonials\/files\/2015\/04\/176385.png","class":"","content":"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur."}},"styled-testimonial-2":{"id":"styled-testimonial-2","name":"Styled Testimonial-2","settings":{"style":"style-2","name":"Antonina","designation":"Executive Manager","company":"XYZ Ltd","url":"#","radius":"0","image":"https:\/\/demo.mythemeshop.com\/wp-testimonials\/files\/2015\/04\/176385.png","class":"","content":"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur."}},"styled-testimonial-3":{"id":"styled-testimonial-3","name":"Styled Testimonial-3","settings":{"style":"style-3","name":"Antonina","designation":"Executive Manager","company":"XYZ Ltd","url":"#","radius":"0","image":"https:\/\/demo.mythemeshop.com\/wp-testimonials\/files\/2015\/04\/176385.png","class":"","content":"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur."}},"styled-testimonial-4":{"id":"styled-testimonial-4","name":"Styled Testimonial-4","settings":{"style":"style-4","name":"Antonina","designation":"Executive Manager","company":"XYZ Ltd","url":"#","radius":"0","image":"https:\/\/demo.mythemeshop.com\/wp-testimonials\/files\/2015\/04\/176385.png","class":"","content":"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur."}},"styled-testimonial-5":{"id":"styled-testimonial-5","name":"Styled Testimonial-5","settings":{"style":"style-5","name":"Antonina","designation":"Executive Manager","company":"XYZ Ltd","url":"#","radius":"0","image":"https:\/\/demo.mythemeshop.com\/wp-testimonials\/files\/2015\/04\/176385.png","class":"","content":"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur."}}}', 'progress_bar' => '{"simple":{"id":"simple","name":"Simple","settings":{"style":"default","percent":"93","text":"UI\/UX","text_position":"above","show_percent":"yes","bar_color":"#ba4c7c","text_color":"#000000","fill_color":"#e1e1e1","height":"15","radius":"0","duration":"1.5","delay":"0.5","class":"","content":"false"}},"thin-bar":{"id":"thin-bar","name":"Thin Bar","settings":{"style":"striped","percent":"73","text":"Development","text_position":"above","show_percent":"yes","bar_color":"#5d90e2","text_color":"#000000","fill_color":"#ccd6e2","height":"5","radius":"0","duration":"1.5","delay":"0.5","class":"","content":"false"}},"animated-bar":{"id":"animated-bar","name":"Animated Bar","settings":{"style":"animated","percent":"83","text":"Design","text_position":"below","show_percent":"yes","bar_color":"#e0534e","text_color":"#000000","fill_color":"#dd9999","height":"23","radius":"0","duration":"1.5","delay":"0.5","class":"","content":"false"}},"striped-bar":{"id":"striped-bar","name":"Striped Bar","settings":{"style":"striped","percent":"83","text":"Design","text_position":"over","show_percent":"yes","bar_color":"#48aace","text_color":"#ffffff","fill_color":"#cee0dd","height":"23","radius":"10","duration":"1.5","delay":"0.5","class":"","content":"false"}},"pie":{"id":"pie","name":"Pie","settings":{"style":"pie","percent":"95","text":"WordPress","text_position":"over","show_percent":"yes","bar_color":"#3aa887","text_color":"#000000","fill_color":"#b8d1b1","height":"23","radius":"10","duration":"1.5","delay":"0.5","class":"","content":"false"}}}', 'modal' => '{"default":{"id":"default","name":"Default","settings":{"effect":"19","button_text":"Open Modal","close_button":"yes","modal_title":"Modal Title","title_color":"#fff","color":"#fff","background":"#95a5a6","overlay_background":"#95a5a6","shadow":"0px 0px 0px ","border":"0px solid ","radius":"0","class":"","content":"\u003Cp\u003EHTML Ipsum Presents\u003C\/p\u003E\n\u003Cul\u003E\n   \u003Cli\u003E\u003Cstrong\u003ELipsum:\u003C\/strong\u003E Morbi in sem quis dui placerat ornare. Pellentesque odio nisi, euismod in, pharetra a, ultricies in, diam. Sed arcu. Cras consequat.\u003C\/li\u003E\n   \u003Cli\u003E\u003Cstrong\u003ELipsum:\u003C\/strong\u003E Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus.\u003C\/li\u003E\n   \u003Cli\u003E\u003Cstrong\u003ELipsum:\u003C\/strong\u003E Phasellus ultrices nulla quis nibh. Quisque a lectus. Donec consectetuer ligula vulputate sem tristique cursus. Nam nulla quam, gravida non, commodo a, sodales sit amet, nisi.\u003C\/li\u003E\n\u003C\/ul\u003E"}},"danger":{"id":"danger","name":"Danger","settings":{"effect":"8","button_text":"Open Modal","close_button":"yes","modal_title":"Modal Title","title_color":"#fff","color":"#fff","background":"#dd5f5f","overlay_background":"#dd7373","shadow":"0px 0px 5px #8e8e8e","border":"1px solid #dd3333","radius":"0","class":"","content":"\u003Cp\u003EHTML Ipsum Presents\u003C\/p\u003E\n\u003Cul\u003E\n   \u003Cli\u003E\u003Cstrong\u003ELipsum:\u003C\/strong\u003E Morbi in sem quis dui placerat ornare. Pellentesque odio nisi, euismod in, pharetra a, ultricies in, diam. Sed arcu. Cras consequat.\u003C\/li\u003E\n   \u003Cli\u003E\u003Cstrong\u003ELipsum:\u003C\/strong\u003E Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus.\u003C\/li\u003E\n   \u003Cli\u003E\u003Cstrong\u003ELipsum:\u003C\/strong\u003E Phasellus ultrices nulla quis nibh. Quisque a lectus. Donec consectetuer ligula vulputate sem tristique cursus. Nam nulla quam, gravida non, commodo a, sodales sit amet, nisi.\u003C\/li\u003E\n\u003C\/ul\u003E"}},"standard":{"id":"standard","name":"Standard","settings":{"effect":"12","button_text":"Open Modal","close_button":"yes","modal_title":"Modal Title","title_color":"#000000","color":"#000000","background":"#ecf0f1","overlay_background":"#e2dee2","shadow":"0px 0px 0px ","border":"0px  ","radius":"0","class":"","content":"\u003Cp\u003EHTML Ipsum Presents\u003C\/p\u003E\n\u003Cul\u003E\n   \u003Cli\u003E\u003Cstrong\u003ELipsum:\u003C\/strong\u003E Morbi in sem quis dui placerat ornare. Pellentesque odio nisi, euismod in, pharetra a, ultricies in, diam. Sed arcu. Cras consequat.\u003C\/li\u003E\n   \u003Cli\u003E\u003Cstrong\u003ELipsum:\u003C\/strong\u003E Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus.\u003C\/li\u003E\n   \u003Cli\u003E\u003Cstrong\u003ELipsum:\u003C\/strong\u003E Phasellus ultrices nulla quis nibh. Quisque a lectus. Donec consectetuer ligula vulputate sem tristique cursus. Nam nulla quam, gravida non, commodo a, sodales sit amet, nisi.\u003C\/li\u003E\n\u003C\/ul\u003E"}},"dark":{"id":"dark","name":"Dark","settings":{"effect":"4","button_text":"Open Modal","close_button":"yes","modal_title":"Modal Title","title_color":"#ffffff","color":"#ffffff","background":"#2c3e50","overlay_background":"#07244f","shadow":"0px 0px 0px ","border":"0px  ","radius":"0","class":"","content":"\u003Cp\u003EHTML Ipsum Presents\u003C\/p\u003E\n\u003Cul\u003E\n   \u003Cli\u003E\u003Cstrong\u003ELipsum:\u003C\/strong\u003E Morbi in sem quis dui placerat ornare. Pellentesque odio nisi, euismod in, pharetra a, ultricies in, diam. Sed arcu. Cras consequat.\u003C\/li\u003E\n   \u003Cli\u003E\u003Cstrong\u003ELipsum:\u003C\/strong\u003E Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus.\u003C\/li\u003E\n   \u003Cli\u003E\u003Cstrong\u003ELipsum:\u003C\/strong\u003E Phasellus ultrices nulla quis nibh. Quisque a lectus. Donec consectetuer ligula vulputate sem tristique cursus. Nam nulla quam, gravida non, commodo a, sodales sit amet, nisi.\u003C\/li\u003E\n\u003C\/ul\u003E"}},"classic":{"id":"classic","name":"Classic","settings":{"effect":"7","button_text":"Open Modal","close_button":"yes","modal_title":"Modal Title","title_color":"#ffffff","color":"#ffffff","background":"#919191","overlay_background":"#d3d3d3","shadow":"0px 0px 0px ","border":"0px  ","radius":"0","class":"","content":"\u003Cp\u003EHTML Ipsum Presents\u003C\/p\u003E\n\u003Cul\u003E\n   \u003Cli\u003E\u003Cstrong\u003ELipsum:\u003C\/strong\u003E Morbi in sem quis dui placerat ornare. Pellentesque odio nisi, euismod in, pharetra a, ultricies in, diam. Sed arcu. Cras consequat.\u003C\/li\u003E\n   \u003Cli\u003E\u003Cstrong\u003ELipsum:\u003C\/strong\u003E Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus.\u003C\/li\u003E\n   \u003Cli\u003E\u003Cstrong\u003ELipsum:\u003C\/strong\u003E Phasellus ultrices nulla quis nibh. Quisque a lectus. Donec consectetuer ligula vulputate sem tristique cursus. Nam nulla quam, gravida non, commodo a, sodales sit amet, nisi.\u003C\/li\u003E\n\u003C\/ul\u003E"}}}', 'section' => '{"image-section":{"id":"image-section","name":"Image Section","settings":{"size":"full-boxed","height":"500px","background_color":"#a3a3a3","background":"http:\/\/demo.mythemeshop.com\/justfit-yoga\/files\/2016\/10\/yoga.jpg","background_size":"cover","background_repeat":"no-repeat","background_mode":"fixed","align_content_vertical":"center","align":"left","content_width":"60%","content_bg":"","content_color":"#ffffff","padding":"40","margin":"15","class":"","content":"[wps_heading align=\"left\" size=\"35\" font_weight=\"bold\" font_style=\"normal\" margin=\"30\"]An Exuberant Explosion of Blissfulness[\/wps_heading]\n[wps_button style=\"default\" url=\"#\" target=\"blank\" background=\"#d1833d\" color=\"#FFFFFF\" size=\"15\" wide=\"no\" position=\"left\" radius=\"5\" text_shadow=\"0px 0px 0px \"]Grab this Theme now![\/wps_button]\n"}},"parallax-section":{"id":"parallax-section","name":"Parallax Section","settings":{"size":"full-boxed","height":"100vh","background_color":"","background":"https:\/\/demo.mythemeshop.com\/moneyflow\/files\/2015\/05\/photo-1431352922605-7436d323b934.jpeg","background_size":"cover","background_repeat":"no-repeat","background_mode":"parallax","align_content_vertical":"center","align":"center","content_width":"100%","content_bg":"","content_color":"#ffffff","padding":"30","margin":"15","class":"","content":"[wps_heading align=\"center\" size=\"40\" font_weight=\"bold\" font_style=\"normal\" margin=\"20\"]Pellentesque habitant morbi tristique senectus et netus[\/wps_heading]\n[wps_button style=\"default\" url=\"#\" target=\"blank\" background=\"#d1626f\" color=\"#FFFFFF\" size=\"18\" wide=\"no\" position=\"center\" radius=\"0\" text_shadow=\"0px px px \"]FIND OUT MORE[\/wps_button]"}}}', 'photo_panel' => '{"default":{"id":"default","name":"Default","settings":{"background":"#f5f5f5","color":"#000","photo":"https:\/\/demo.mythemeshop.com\/moneyflow\/files\/bfi_thumb\/pexels-photo-262226-331e0sw5qm38pwmxta2dqi.jpeg","align":"left","radius":"0","shadow":"0px 0px px ","border":"px  ","url":"#","class":"","content":"Image Caption"}},"colored-caption-1":{"id":"colored-caption-1","name":"Colored Caption","settings":{"background":"#966b9d","color":"#fff","photo":"https:\/\/demo.mythemeshop.com\/moneyflow\/files\/bfi_thumb\/pexels-photo-25877-331easvmiv5qww6oc2qxvu.jpg","align":"left","radius":"0","shadow":"0px 0px 10px #aeaeae","border":"1px solid #bababa","url":"#","class":"","content":"Image Caption"}},"colored-caption-2":{"id":"colored-caption-2","name":"Colored Caption-2","settings":{"background":"#fc345c","color":"#fff","photo":"https:\/\/demo.mythemeshop.com\/newstoday\/files\/2017\/06\/pexels-photo-195280-330x186.jpeg","align":"left","radius":"0","shadow":"0px 0px 0px ","border":"0px  ","url":"#","class":"","content":"Stories"}}}',
			'icon_list' => '{"icon-list-1":{"id":"icon-list-1","name":"Icon-list 1","settings":{"icon":"wechat","title":"Lorem Ipsum Dolar","align":"top-left","background":"","color":"#35ce8d","shadow":"","border":"","radius":"","url":"#","size":"50","animate":"","class":"","content":"Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo."}},"icon-list-2":{"id":"icon-list-2","name":"Icon-list 2","settings":{"icon":"building-o","title":"Lorem Ipsum Dolar","align":"title","background":"","color":"#6aa2ff","shadow":"","border":"","radius":"","url":"#","size":"50","animate":"","class":"","content":"Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo."}},"icon-list-3":{"id":"icon-list-3","name":"Icon-list 3","settings":{"icon":"rocket","title":"Lorem Ipsum Dolar","align":"center","background":"#23395b","color":"#ffffff","shadow":"","border":"","radius":"0","url":"#","size":"25","animate":"","class":"","content":"Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo."}}}',);
		$preset_prefix = 'wps_presets_';
		foreach($preset_data as $shortcode => $data) {
			$preset_data = json_decode($data, 1);
			$option_key = $preset_prefix.$shortcode;
			$presets = get_option($option_key);
			if(!empty($presets)) {
				$preset_data = array_merge($preset_data,$presets);
			}
			update_option( $option_key, $preset_data );
		}

		$shortcode_options = get_option('wp-shortcode-options-general');
		if(!isset($shortcode_options['wps_prefix'])) {
			$options = array();
			$options['wps_prefix'] = 'wps_';
			update_option('wp-shortcode-options-general', $options);
		}

		add_option( 'wps_redirect_settings', true );
	}
}