const finish = 20
let i = 0
const square = document.querySelectorAll('div')[0];

const hue = () => {
	return 'rgb(' + (Math.floor(Math.random() * 256)) + ',' + (Math.floor(Math.random() * 256)) + ',' + (Math.floor(Math.random() * 256)) + ')';
}
const size = (max = 200, min = 50, unit = px) => {
	return Math.floor(Math.random() * (max - min)) + min +unit;
}

const voices = window.speechSynthesis.getVoices();

const speak = (text) => {
	const msg = new SpeechSynthesisUtterance()
	msg.text = text
	msg.voice = voices[5]
	window.speechSynthesis.speak(msg)
}

const randomize = (el) => {
	Object.assign(
		el
		.style,{
			background: hue(),
			height: size(100,50, 'px'),
			width: size(100,50, 'px'),
			marginTop: size(-80,80, 'vh'),
			marginLeft: size(-80,80, 'vw'),
		}
	)
	el.innerText = i++
	
	if (el.innerText == finish) {
		i = 1
	}
}

square.addEventListener('click', function(){
	randomize(square)
	window.speechSynthesis.cancel()
	speak(this.innerText)
})

randomize(square)