var debug = 0;//0 - off | 1 - basic messages | 2 - timer & cookie info | 3 - key presses & timestamp & more | 4 - display basically all stats

$(document).ready(function(){

	var version = 1124;
	//console.log("=== CURRENT VERSION: "+version+" ===");

	var letters = ["A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z"];
	var letterDelay = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
	var curLetter = 0, errorCount = 0, avgCount = 0, KPSCounter = 0;
	var bestTime =(getCookie("alphabetTyper_bestTime") !== ""?getCookie("alphabetTyper_bestTime"):999);
	var avgTime = (getCookie("alphabetTyper_avgOfTen") !== ""?getCookie("alphabetTyper_avgOfTen"):0);
	var last10Solves = (getCookie("alphabetTyper_avgArray") !== ""?(getCookie("alphabetTyper_avgArray").split(",").map(Number)):[]);

	var startTime = window.performance.now();
	var curTime = 0.000;
	var timer = {
		running: false,
		start: function(){timer.running = true;startTime = window.performance.now();if(debug >= 4){console.log("Called - timer.start");}},
		tick: function(){
			var ticks = setInterval(function(){
				curTime = formatNum((window.performance.now() - startTime) / 1000);
				$(".timer-display").text("Time: "+curTime);
				if(!timer.running){clearInterval(ticks);}
			},1);
		},
		reset: function(){
			setTimeout(function(){
				curTime = 0;$(".timer-display").text("Time: 0.000");}
			,2);
			if(debug >= 4){console.log("Called - timer.reset");}
		},
		stop: function(){timer.running = false;if(debug >= 4){console.log("Called - timer.stop");}}
	};
	
	var highlightLetter = function(letter){
		var start = letters.indexOf(letter);		
		var before = "";
		for(var i2=0;i2<start;i2++){before += letters[i2];}
		$(".beforeletters").text(before);
		$(".curletter").text(letters[start]);
		var after = "";
		for(var i=0;i<letters.length - start - 1;i++){after += letters[i+start + 1];}
		$(".afterletters").text(after);
		
		//if last letter was pressed (aka you won)
		if(letter === letters[letters.length]){
			if(debug >= 1){console.log("Alphabet Finished!"+(debug >= 2?(" Time: "+curTime):""));}
			timer.stop();
			curLetter = 0;errorCount = 0;avgCount++;

			//reset letters
			$(".curletter").text(letters[curLetter]);
			$(".afterletters").text(after.substr(1,after.length-1));

			//have timer jump forward for a few and glow gold when finished
			$(".timer-display").addClass("won");
			setTimeout(function(){$(".timer-display").removeClass("won");},375);
			
			//check for new fastest time
			setTimeout(function(){
				//average calculation and update
				if(last10Solves.length >= 10){last10Solves.pop();}
				last10Solves.unshift(curTime);var avgTemp = 0;
				for(var i=0;i<last10Solves.length;i++){avgTemp += Number(last10Solves[i]);}
				avgTime = avgTemp / last10Solves.length;
				$(".average-time").text("Avg of 10: "+formatNum(avgTime));
				setCookie("alphabetTyper_avgOfTen",formatNum(avgTime));
				setCookie("alphabetTyper_avgArray",last10Solves);
				
				if(curTime < bestTime){
					playSound("best");
					bestTime = curTime;
					setCookie("alphabetTyper_bestTime",formatNum(bestTime));
				}else{playSound("win");}
				$(".best-time").text("Best Time: "+formatNum(bestTime));
				if(debug >= 4){console.log("=== CURRENT COOKIES === "+document.cookie);}
			},1);
		}
		
	};
	
	/* Listen for keypresses */
	var curTimePress=0;
	$(document).keydown(function(e){
		var keyCodeStart = 65;
		
		//prevent certain keys from fucking you up, aka tab
		if(e.keyCode == 9){e.precentDefault();}
		
		//if beginning new solve
		if(e.keyCode == keyCodeStart && !timer.running){
			timer.start();timer.tick();
			errorCount=0;$(".errors-display").text("Errors: "+errorCount);
		}
		
		if(e.keyCode == keyCodeStart + curLetter && curLetter < letters.length){//if correct key was pressed
			curLetter++;KPSCounter++;oldKPS = KPSCounter;
			var pressTimestamp = Number(formatNum(curTime));
			if(curLetter<=1){curTimePress=0;lastTimePress=0;}else{
				letterDelay[curLetter-2] = curTime;
				curTimePress = curTime;
			}
			updateGraph(Number(curLetter-1), Number(curTimePress));
			highlightLetter(letters[curLetter]);
			playSound("hit");
		}else if(e.keyCode === 32 || e.keyCode === 27){//if space or esc was pressed
			if(debug >= 4){console.log("Timer resetting, last run had "+errorCount+" errors, and made it to letter '"+letters[curLetter]+"'");}
			curLetter = 0;errorCount = 0;
			highlightLetter(letters[curLetter]);
			timer.stop();timer.reset();
			resetGraph();
			errorCount=0;$(".errors-display").text("Errors: "+errorCount);
		 }else{//if unknown key was pressed (aka wrong key)
			playSound("miss");
			errorCount++;$(".errors-display").text("Errors: "+errorCount);
			if(debug >= 3){console.log("Wrong letter pressed"+(debug >= 3?(" at "+curTime):""));}
			var shakeCount = 0;
			var shake = function(){
				setTimeout(function(){
					shakeCount++;
					$(".letter-display .curletter").css({"color":"#f44","text-shadow":"0 0 30px rgba(255,100,100,.75)","padding":"0 "+(shakeCount%2==1?15:5)+"px 0 "+((shakeCount+1)%2==1?15:5)+"px"});
					if(shakeCount < 6){shake();}else{$(".letter-display .curletter").css({"color":"#eee","text-shadow":"0 0 30px rgba(255,255,255,.75)","padding":"0 10px"});}
				},50);
			};
			shake();
		}
	});
	
	var maxDelay = 0, graphPoints=[], graphData=[];
	var lastDelay = 0, resultPoints="";
	var resetGraph = function(){
		resultPoints = "";
		maxDelay = 0;lastDelay = 0;
		graphPoints = [];graphData = [];
		//update yaxis text
		var yAxisText = $(".graph .text .yaxis > div");
		for(var i=0;i<yAxisText.length;i++){
			var axisNum = (1*(i/(yAxisText.length-1)));
			var digits = (axisNum>=0&&axisNum<1)?2:((axisNum>=1&&axisNum<10)?1:0);
			yAxisText.eq(i).text(parseFloat(axisNum.toFixed(digits)));
		}
		$(".graph .points .line").attr("d", resultPoints);
	};
	var updateGraph = function(letNum, del){
		var letterNum = parseFloat(letNum), delay = parseFloat(del);
		var graphHeight = $(".graph .grid").height(), timeTaken = (curTime-lastDelay);
		var updatePrevPoints = false;
		
		//new run, reset graph
		if(letterNum === 0){resetGraph();}
		
		if(timeTaken > maxDelay){
			maxDelay = timeTaken;
			if(letterNum>=1){updatePrevPoints = true;}
		}
		lastDelay = delay;
		graphData[letterNum] = timeTaken;
		
		var curPointVal = (graphData[letterNum]/maxDelay)*graphHeight;
		graphPoints[letterNum] = curPointVal;
		
		//update past points if max is updated
		if(updatePrevPoints){
			console.log("UPDATE LAST POINTS!!!!!");
			
			//update yaxis text
			var yAxisText = $(".graph .text .yaxis > div");
			for(var i=0;i<yAxisText.length;i++){
				var axisNum = (maxDelay*(i/(yAxisText.length-1)));
				var digits = (axisNum>=0&&axisNum<1)?2:((axisNum>=1&&axisNum<10)?1:0);
				yAxisText.eq(i).text(parseFloat(axisNum.toFixed(digits)));
			}
			
			//scale down all previous points accordingly
			for(var i=1;i<graphPoints.length;i++){
				graphPoints[i] = (graphData[i]*graphHeight)/maxDelay;
			}
		}
		
		//set resultPoints as graphPoints
		//but in proper d attribute format
		for(var i=0;i<graphPoints.length;i++){
			if(i === 0){
				resultPoints = "M0,"+graphHeight+" ";
			}else{
				if(i === 1){resultPoints += "L";}
				resultPoints += ""+(i*22)+","+(graphHeight-graphPoints[i])+" ";
			}
		}
		
		$(".graph .points .line").attr("d", resultPoints);
		
	};
	
	var playSound = function(which){
		if(which === "hit"){
			$(".audio .right").prop("currentTime",0);
			$(".audio .right").trigger("play");
		}else if(which === "miss"){
			$(".audio .wrong").prop("currentTime",0);
			$(".audio .wrong").trigger("play");
		}else if(which === "win"){
			$(".audio .win").prop("currentTime",0);
			$(".audio .win").trigger("play");
		}else if(which === "best"){
			$(".audio .best").prop("currentTime",0);
			$(".audio .best").trigger("play");
		}
	};

	//WILL ALWAYS RETURN STRING, CAST TO NUMBER TO FIX
	var formatNum = function(num, decimalPlaces){
		var result = ""+(typeof num === "string" ?Number(num):num).toFixed((typeof decimalPlaces === "number")?decimalPlaces:3);
		if(result.indexOf(".") === -1){result+=".";for(var i=0;i<decimalPlaces;i++){result += "0";}}else{
			var fixDec = result.split(".")[1];
			for(var i=0;i<decimalPlaces;i++){if(fixDec.length != decimalPlaces){fixDec += "0";}}
			result = result.split(".")[0]+"."+fixDec;
		}
		return result;
	};
	
	var oldKPS = KPSCounter;
	var updateKPS = setInterval(function(){
		if(KPSCounter > (oldKPS / 100)){
			KPSCounter -= (KPSCounter > 0.1?(oldKPS / 100):0);
		}else{KPSCounter = 0.00001;}
		if(KPSCounter >= 1){$(".kps-counter").text("KPS: "+formatNum(KPSCounter,1));
		}else{if($(".kps-counter").text() !== "KPS: 0.0"){$(".kps-counter").text("KPS: 0.0");}}
	},10);
	
	highlightLetter(letters[curLetter]);

	var initCookies = function(){
		if(getCookie("alphabetTyper_bestTime") !== "" && getCookie("alphabetTyper_avgOfTen") !== "" && getCookie("alphabetTyper_avgArray") !== ""){
			var oldBestTime = getCookie("alphabetTyper_bestTime"), oldAvg = getCookie("alphabetTyper_avgOfTen");
			$(".average-time").text("Avg of 10: "+avgTime);
			$(".best-time").text("Best Time: "+bestTime);
			if(debug >= 2){console.log("Loading cookies: bestTime - "+oldBestTime+" | avgTime - "+oldAvg+" | avgArray - ["+getCookie("alphabetTyper_avgArray")+"]");}
		}
	};

	setTimeout(function(){initCookies();},1);
	
	function getCookie(name){
		if(document.cookie === ""){return "";}
		var cookie = document.cookie.match(/[^=]+=([^;]+);? ?/g), result = "";
		for(var i=0;i<cookie.length;i++){
			if(cookie[i].startsWith(name)){result = cookie[i];}
		}
		//if(result === ""){console.error("ERROR: Cookie '"+name+"' was not found.");}
		var cookieName = (result.split("=")[0] !== undefined ? result.split("=")[0].trim() : ""); //not used, but I put it here just incase
		var cookieValue = (result.split("=")[1] !== undefined ? result.split("=")[1].trim().substring(0,result.split("=")[1].trim().length) : "");
		if(cookieValue.substring(cookieValue.length - 1, cookieValue.length) === ";"){cookieValue = cookieValue.substring(0, cookieValue.length - 1);}
		return cookieValue;
	};
	function setCookie(name, val){
		document.cookie=""+name+"="+val+";expires="+(new Date((new Date()).getTime() + 7 * 24 * 60 * 60 * 1000).toUTCString())+";";
	};
	function delCookie(name){document.cookie=name+'=;expires=Thu, 01 Jan 1970 00:00:01 GMT;';};
	
});
console.clear();