// VARIABLES"be
var easyWords = ["ANYWHERE", "AUNT", "BANGS", "BEARD", "BLOND", "BLOUSE", "BRAIDS", "BROWN", "COUSIN", "CURLY", "FAMILY", "GLASSES", "GRANDMA", "GRANDPA", "GRAY", "MOUSTACHED", "PONYTAIL", "SANDALS", "SNEAKERS", "SOMEONE", "STRAIGHT", "SUIT", "UNCLE", "VEST", "YOUNGER", "SISTER"];
var currentWord;
var lives;
var letterClickable; // enables or disables ability to click the letter, used once the game is over
var selectedDifficulty = $('input[name=difficulty]:checked', '#difficulty-form').val(); // grabs selected radio button
var wins = 0;
var losses = 0;

// EVENTS
$(document).ready(function() {
  gameSetup(selectedDifficulty); // sets up a new game with the selected difficulty
});

$("#new-game").click(function() {
  gameSetup(selectedDifficulty);
});

$("#reset-btn").on("click", function(){
  resetScore();
});

$(".letter-btn").click(function() {
  if (letterClickable) { // makes sure the letter is allowed to be clicked
    var currentLetter = $(this).text(); // stores the chosen letter
    var correctLetters = checkLetter(currentLetter); // iterates through the word and returns any matches with the chosen letter
    updateUnderscores(correctLetters, currentLetter); // replaces underscores with the chosen letter if it's correct
    checkOutcome();
    $(this).prop("disabled", true); // disables the letter
  }
});

// When difficulty is changed, reset score and start a new game with a word from the chosen level
$('#difficulty-form input').on('change', function() {
  selectedDifficulty = $('input[name=difficulty]:checked', '#difficulty-form').val();
  resetScore();
  gameSetup(selectedDifficulty);
});


// FUNCTIONS
// resets all variables back to starting values and chooses a new word
function gameSetup(difficulty) {
  $("#underscores").empty();
  letterClickable = true; // makes all letters clickable
  lives = 6;
  hangmanUpdate(); //updates the image state
  selectWord(difficulty);
  drawUnderscores();
  $(".letter-btn").prop("disabled", false); //enables all buttons
  $("#outcome").css("z-index", "-10"); // hides the outcome popup
  $("#outcome").css("opacity", "0");
}

// generates a random integer between the passed values
function genRnd(min, max) {
  min = Math.ceil(min);
  max = Math.floor(max);
  return Math.floor(Math.random() * (max - min)) + min;
}

// based on the passed value, selects a random word from the appropriate difficulty word list
function selectWord(difficulty) {
  if (difficulty == "easy") {
    var word = genRnd(0, easyWords.length);
    currentWord = easyWords[word];
  }
  else if (difficulty == "medium") {
    var word = genRnd(0, mediumWords.length);
    currentWord = mediumWords[word];
  }
  else {
    var word = genRnd(0, hardWords.length);
    currentWord = hardWords[word];
  }
}

// for each letter in the selected word, draw an underscore
function drawUnderscores() {
  for (var i = 0; i < currentWord.length; i++) { 
    $("#underscores").append('<p class="letter">_</p>');
  }
}

// checks if the chosen letter matches any letters in the current word
function checkLetter(letter) {
  var corrects = [];
  for (var i = 0; i < currentWord.length; i++) {
    if (letter == currentWord[i]) { // if yes, it pushes it into the "corrects" array
      corrects.push(i);
    }
  }
  return corrects; // returns all the letter that matched
}

// Updates the hangman image, as well the lives left. 
function hangmanUpdate() {
  $("#lives-span").text(lives);
  var image = 7 - lives; // The images are all named the same, only last number changes. Since there are 6 images, this determines which one should be used
  $("#hangman-img").attr("src", `https://raw.githubusercontent.com/edgenard/hsgc-jquery-hangman/master/images/hangman-${image}.png`); // grabs image with appropriate number
}

function updateUnderscores(correctLetters, currentLetter) {
  if (correctLetters.length !== 0) { // if there are any correctly guessed letters
    for (var i = 0; i < correctLetters.length; i++) { // for each one of them
      $("#underscores p:eq(" + correctLetters[i] + ")").text(currentLetter); // replace the underscore with the letter
    }
  }
  else { // if there are none correct, count as an incorrect guess and substract a life. Update hangman image accordingly
    lives--;
    hangmanUpdate();
  }
}

// Updates the win/loss score variables, and the on-screen text
function updateScore(outcome) {
  if (outcome == "win") {
    wins++;
    $("#win-score").text(wins);
  }
  else if (outcome == "loss") {
    losses++;
    $("#loss-score").text(losses);
  }
  else { // if this function gets run without a win or a loss (i.e. new game, difficulty change etc.) it simply updates the on-screen values to reflect the variables 
    $("#win-score").text(wins);
    $("#loss-score").text(losses);
  }
}

// resets score back to 0, and updates on-screen values
function resetScore() {
  wins = 0;
  losses = 0;
  updateScore();
}

function checkOutcome() {
  var corrects = 0;
  if (lives === 0) { // if the player is out of lives, the loss function is run
    loss();
  }
  
  // for each character, check if it's an underscore. If it isn't, it means it has replaced with a letter and is therefore a correct guess.
  $("#underscores > p").each(function(i) {
    if ($(this).text() != "_") { 
      corrects++;
    }
  });
  
  // if the number of non-underscores is the same as the amount of characters in the word, it means all have been correctly guessed
  if (corrects == currentWord.length) {
    win(); // runs the victory :)
  }
  else {
    corrects = 0; // if the numbers aren't equal, not all letters have been guessed. Reset the "corrects" variable for the next check
  }
}

// Shows the popup with the correct win/loss message, and styles it accordingly
function win() {
  $("#outcome").text("You Win!");
  letterClickable = false; // disables more letters from being played
  $("#outcome").css("z-index", "10");
  $("#outcome").css("background", "#2ecc71"); // a nice victorious green :)
  $("#outcome").css("opacity", "1");
  updateScore("win"); //updates the scores, passing in your amazing win
}

function loss() {
  $("#outcome").text("Game Over! The word was " + currentWord); // tells the player what the correct word was
  letterClickable = false;
  $("#outcome").css("z-index", "10");
  $("#outcome").css("background", "#e74c3c");
  $("#outcome").css("opacity", "1");
  updateScore("loss");
}